import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 10))

# Define the grid size
rows, cols = 5, 4

# Define the colors for clear and painted tiles
clear_color = 'lightgreen'
white_paint_color = 'white'
black_paint_color = 'black'

# Define the robot colors
robot1_color = 'white'
robot2_color = 'black'

# Define the tile status for the goal state
tile_status = {
    'tile_0-1': 'clear', 'tile_0-2': 'clear', 'tile_0-3': 'clear', 'tile_0-4': 'clear',
    'tile_1-1': 'painted white', 'tile_1-2': 'painted black', 'tile_1-3': 'painted white', 'tile_1-4': 'painted black',
    'tile_2-1': 'painted black', 'tile_2-2': 'painted white', 'tile_2-3': 'painted black', 'tile_2-4': 'painted white',
    'tile_3-1': 'painted white', 'tile_3-2': 'painted black', 'tile_3-3': 'painted white', 'tile_3-4': 'painted black',
    'tile_4-1': 'painted black', 'tile_4-2': 'painted white', 'tile_4-3': 'painted black', 'tile_4-4': 'painted white',
}

# Draw the tiles
for row in range(rows):
    for col in range(cols):
        tile_id = f'tile_{row}-{col+1}'
        status = tile_status[tile_id]
        if 'painted white' in status:
            color = white_paint_color
        elif 'painted black' in status:
            color = black_paint_color
        else:
            color = clear_color
        rect = patches.Rectangle((col, rows-row-1), 1, 1, linewidth=1, edgecolor='black', facecolor=color)
        ax.add_patch(rect)
        ax.text(col + 0.5, rows-row-0.5, tile_id, ha='center', va='center', fontsize=8, color='black' if color != black_paint_color else 'white')

# Draw the robots at the bottom with "no constraints" status
robot1_position = (0.5, -0.5)
robot2_position = (1.5, -0.5)

circle1 = patches.Circle(robot1_position, 0.3, edgecolor='black', facecolor=robot1_color)
ax.add_patch(circle1)
ax.text(robot1_position[0], robot1_position[1] - 0.2, 'robot1\n(no constraints)', ha='center', va='center', fontsize=8, color='black')

circle2 = patches.Circle(robot2_position, 0.3, edgecolor='black', facecolor=robot2_color)
ax.add_patch(circle2)
ax.text(robot2_position[0], robot2_position[1] - 0.2, 'robot2\n(no constraints)', ha='center', va='center', fontsize=8, color='white')

# Set limits and labels
ax.set_xlim(0, cols)
ax.set_ylim(-1, rows)
ax.set_xticks([])
ax.set_yticks([])

# Add legend
legend_elements = [
    patches.Patch(facecolor=clear_color, edgecolor='black', label='Clear Tile'),
    patches.Patch(facecolor=white_paint_color, edgecolor='black', label='Painted White'),
    patches.Patch(facecolor=black_paint_color, edgecolor='black', label='Painted Black'),
    patches.Patch(facecolor=robot1_color, edgecolor='black', label='Robot1 (White)'),
    patches.Patch(facecolor=robot2_color, edgecolor='black', label='Robot2 (Black)'),
]
ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.3, 1))

# Save the figure
plt.savefig('tiles/one_shot/goal_diagram_code/attempts/goal_diagram_attempt_11.png', bbox_inches='tight')
plt.show()
# VERIFICATION FAILED:
# Robots are shown outside the grid, which is not a valid position.
